/*  This file is part of Lime Survey Template : SkeletonQuest

  Copyright (C) 2010-2014 Denis Chenu for http://sondages.pro
  Distributed under GPL 3 licence
  Distributed under MIT licence

  Inspiration by jquery mobile http://jquerymobile.com/ under Dual licensed under the MIT or GPL Version 2 licenses.
*/
var console=console||{"log":function(){}};

bHaveJquery=false;
// Some var to enable/disable some function
useDefaultProgress=false; // Use the default progress-wrapper from LimeSurvey core
replaceJavascriptAlert=true; // Replace common alert with jquery-ui dialog
bMoveLanguageSelect=true // Move the language selector to the top
bCloneNavigator=false // Clone the navigator in the header
bMoveIndex=true // Move index in a fixed box at rigth of the survey
bHeaderFixed=true; // Fix the header

if (window.jQuery) {
	bHaveJquery=true;
	window.onbeforeunload = function() {
		$("body").removeClass("loaded").addClass("loading");
	 };
	disableEnterSubmit();
	fixLabelClass();
	$(document).ready(function(){
		removeBack();
		addScrollTop();
		fixSelectWidth();
		if(bMoveLanguageSelect || bCloneNavigator){$("<div class='tools cloned-tools' />").appendTo("#head .wrapper");}
		if(bCloneNavigator){cloneNavigator();}
		if($("#changelangbtn").length && bMoveLanguageSelect){moveLanguageSelect();}
		if( ($("#changelangbtn").length && bMoveLanguageSelect) || bCloneNavigator){fixTitleWidth();}
		if(bHeaderFixed){headerFixed();}
		if(bMoveIndex){updateIndex();}
		hovercolumn();
		tableinput();
		movePrevButton();
		updateSlider();
		// Opera mini labelling touch
		operamini = window.operamini && ({}).toString.call( window.operamini ) === "[object OperaMini]";
		if(operamini){
			$('label > input:checkbox, label > input:radio, input:radio + label, input:checkbox + label').bind('click', function(){
			});
		}
		$("body").removeClass("loading").addClass("loaded");
	})
}else{
	window.onload = function() {
		body = document.getElementsByTagName('body')[0];
		body.className = body.className.replace(/\loading\b/,'loaded');
	};
}
/* Add a hash to the url to disallow previous on survey */
function removeBack(){
	window.location.hash="nbb";
	window.location.hash="";
	window.onhashchange=function(){window.location.hash="";}
}
function navbuttonsJqueryUi(){
	// Do our own button (not jquery default)
	$("#movenextbtn").wrapInner("<span class='btn-text ui-button-text' />").append(" <i class='btn-icon ui-icon ui-icon-arrowthick-1-e'>   </i>");
	$("#moveprevbtn").wrapInner("<span class='btn-text ui-button-text' />").prepend("<i class='btn-icon ui-icon ui-icon-arrowthick-1-w'>   </i> ");
	$("#movesubmitbtn").wrapInner("<span class='btn-text ui-button-text' />").append(" <i class='btn-icon ui-icon ui-icon-arrowthickstop-1-s'>   </i>");
}
/* Adding some element to multi-numeric slider */
function updateSlider()
{
	$(".multinum-slider").wrap("<div class='multinum-slider-container slider-element' />" );
	$(".slider-reset").wrap("<div class='slider-reset-container slider-element' />" );
	$(".slider-list [id^='container-']").slider( "option", "range", "min" );
}
function disableEnterSubmit(){
	$(document).on('keypress','input[type=text],#limesurvey select',function(e){
		var key = e.charCode ? e.charCode : e.keyCode ? e.keyCode : 0;
		if (key == 13) {
			e.preventDefault();
			var inputs = $(this).closest('form').find(':input:visible:enabled,select:visible:enabled,textarea:visible:enabled,button:visible:enabled');
			if ((inputs.length-1) == inputs.index(this))
				$('#movenextbtn,#movesubmitbtn').focus();
			else
				inputs.eq(inputs.index(this) + 1).focus();
		}
	});
}
function noScrollOnSelect()
{
	// Disable the default no scroll on select
}
/* Add a little icon with Scroll to top : /!\ no text put inaccessible */
function addScrollTop(){
	$("<a href='#' class='scrollToTop' aria-hidden='true'>&nbsp;</a>").appendTo("body");
	$(window).scroll(function(){
		if ($(this).scrollTop() > 100) {
			$('.scrollToTop').fadeIn();
		} else {
			$('.scrollToTop').fadeOut();

		}
	});
	$('.scrollToTop').click(function(){
		$('html, body').animate({scrollTop : 0},300);
		return false;
	});
}

/* Fix the max width for all option, for ip(hone|od|ad : add an empty optgroup */
function fixSelectWidth(){
	if (navigator.userAgent.match(/(ip(hone|od|ad))/i)) {
	$('select').each(function(){
		$(this).append("<optgroup label=''></optgroup>");
	});
	}
}
if (window.jQuery) {
// Replace common alert with jquery-ui dialog
	if(window.screen.availWidth > 600 && replaceJavascriptAlert){
		function alert(text) {
			var $dialog = $('<div></div>')
				.html(text)
				.dialog({
					title: '',
					dialogClass: 'alert',
					buttons: { "Ok": function() { $(this).dialog("close"); } },
					show: { effect: "highlight", duration: 800 },
					hide: {effect: "fade",duration: 500},
					modal: true
				});
			$dialog.dialog('open');
		}
	}
}
/* Adapt column hover */
function hovercolumn(){
	$(document).on('mouseover mouseleave',':not(.array-flexible-duel-scale) table.question td',function(event){
		if (event.type == 'mouseover') {
		  $(this).closest("table.question").find("col").eq($(this).index()).addClass("hover");
		  $(this).closest("table.question").find("thead tr").children().eq($(this).index()).addClass("hover");
		}
		else {
		  $(this).closest("table.question").find("col").eq($(this).index()).removeClass("hover");
		  $(this).closest("table.question").find("thead tr").children().eq($(this).index()).removeClass("hover");
		}
	});
	$(document).on('mouseover mouseleave','.array-flexible-duel-scale table.question td',function(event){
		if (event.type == 'mouseover') {
		  $(this).closest("table.question").find("col").eq($(this).index()).addClass("hover");
		  $(this).closest("table.question").find("thead tr:not(.groups)").children().eq($(this).index()).addClass("hover");
		}
		else {
		  $(this).closest("table.question").find("col").eq($(this).index()).removeClass("hover");
		  $(this).closest("table.question").find("thead tr:not(.groups)").children().eq($(this).index()).removeClass("hover");
		}
	});
}
function tableinput(){
	$(document).on('focusin focusout','.array-flexible-duel-scale table.question input',function(event){
		activeindex=$(this).parents('td').index();
		if (event.type == 'focusin') {
		  $(this).closest("td").addClass("focus");
		  $(this).closest("tr").addClass("focus");
		  $(this).closest("table.question").find("col").eq(activeindex).addClass("focus");
		  $(this).closest("table.question").find("thead tr:not(.groups)").children().eq(activeindex).addClass("focus");
		}
		else {
		  $(this).closest("td").removeClass("focus");
		  $(this).closest("tr").removeClass("focus");
		  $(this).closest("table.question").find("col").eq(activeindex).removeClass("focus");
		  $(this).closest("table.question").find("thead tr:not(.groups)").children().eq(activeindex).removeClass("focus");
		}
	});
}
function movePrevButton(){
	if ((screen.width<440)) {
		$('#moveprevbtn').insertAfter('#movenextbtn');
		$('<br />').insertAfter('#movenextbtn');
	}
}
/* Clone the language selector (if exist) in the header*/
function moveLanguageSelect(){
	if($("#changelangbtn").length){
		$(document).on("change",".select-lang",function(){
			$("#lang").val($(this).val()).trigger('change');
		});
		var selectedLang=$("#lang").val();
		newLanguageMenu="<div class='menu-wrapper tool'>"
						+"<select class='select-lang'>"+$("#lang").html()+"</select></div>";
		$(newLanguageMenu).appendTo(".cloned-tools");
		$("#lang").addClass('tool-cloned');
	}
}
/* Fix the title width according to header tools */
function fixTitleWidth() {
	$("#head .pagetitle").width($("#head > .wrapper").width() - $("#head .cloned-tools").outerWidth() - 8);
	$( window ).resize(function() {
		$("#head .pagetitle").width($("#head > .wrapper").width() - $("#head .cloned-tools").outerWidth() - 8);
	});
}
/* Move the index (and accordion it) */
function updateIndex(){
	if($("#index").length){
		//$("#limesurvey").wrapInner("<div id='indexed' />");
		$("#index").appendTo("#content").wrap("<div class='aside aside-index' />");
		$("body").addClass("with-aside");
		$("#content").addClass("with-aside");
		var mainOffset= $("#main").offset().top-$(window).scrollTop();
		minOffset=0+$(".head.affix").outerHeight();
		$("#index").css("top",Math.max(mainOffset,minOffset)+"px");
		$(window).on('scroll',function(){
			mainOffset= $("#main").offset().top-$(window).scrollTop();
			newOffset=Math.max(mainOffset,minOffset);
			$("#index").css("top",Math.max(mainOffset,minOffset)+"px");
		});
		$(document).on('click','#index :submit',function(){
			$(this).clone().removeAttr('id').appendTo("#limesurvey").click();
		});
		// Fix for ranking question type
		if(typeof doDragDropRank!="undefined" && $.isFunction( doDragDropRank )){
			$('.dragDropTable').each(function(){
				var bSameListHeigth=$(this).find(".dragDropChoiceList[style]").length;
				var bSameChoiceHeigth=$(this).find(".choice[style]").length;
				if(bSameListHeigth || bSameChoiceHeigth){
					$(this).find(".choice[style]").removeAttr('style');
					var qID=$(this).closest(".question-wrapper").data('qid');
					fixChoiceListHeight(qID,bSameChoiceHeigth,bSameListHeigth);
				}
			});
		}
//		$(document).on('click','#index .container',function(){
//			$(this).find('ol').toggle();
//		});
	accordionIndex();
	}
}
/* Set accordion to index */
function accordionIndex(){
  if( $('#index .container h3').length > 0 )
  {
	$('#index').addClass('accordion');
	$('#index .container h3').each(function(index){
	  $(this).addClass("grouptitle");
	  $(this).attr("id",'grouptitle-'+index);
	  $(this).after("<div class='group' id='groupindex-"+index+"'></div>");
	  $(this).nextUntil("h3",'.row').appendTo($("#groupindex-"+index))
	});
	// Don't find a good way to use .accordion() then redo it
	$("#index .container .current").closest(".group").addClass("current");
	thiscurrent=$("#index .container .group.current")
	currentindex=$("#index .container .group").index(thiscurrent);
	// Calculate heiht/maxheight
	maxheight=0;
	$("#index .container .group").each(function(){
	  if($(this).height()>maxheight){maxheight=$(this).height();}
	});

	//$("#index .container .group").height(maxheight);
	$("#index .container .group.current").addClass("active");
	$("#index .container .group:not(.current)").addClass("inactive");
	//$("<b class='more seemore ui-icon ui-icon-plus' />").prependTo(("#index .container h3"));
	$("#index .container h3").each(function(index){
		number=parseInt(index)+1;
		$("<i class='more seemore ui-icon ui-icon-plus'>"+number+"</i>").prependTo($(this));
	});
	$("#index .container .active").prev("h3").find(".more").toggleClass('seemore seeless').toggleClass('ui-icon-plus ui-icon-minus');
	$("#index .container .group:not(.active)").hide(0);
	//System to set haven't submit button moving
	containerheight=maxheight*1;
	$("#index .container h3").each(function(){
		containerheight+= $(this).outerHeight()*1;
	});
	$("#index .container > .row").each(function(){
		containerheight+= $(this).outerHeight()*1;
	});
	containerheight+= $("#index .container h2").outerHeight()*1;
	containerheight+=$("#index p.navigator").outerHeight()*1;
	containerheight+=40;// A 40px more
//	$("#index .container").height(containerheight);
	$("#index .container").css('min-height', containerheight+'px');
	$("#content").css('min-height', containerheight+'px');
	$("#index .container h3").click(function(){
	  if(!$(this).next(".group").hasClass('active')){
		$("#index .container .group").slideUp(150);
		$(this).next(".group").slideDown(150);
		$("#index .container .group").removeClass('active');
		$(this).next(".group").addClass('active');
		$("#index .container h3 .more").removeClass('seeless ui-icon-minus').addClass('seemore ui-icon-plus');
		$(this).find('.more').removeClass('seemore ui-icon-plus').addClass('seeless ui-icon-minus');
		$("#index .toggleall").removeClass('seeless ui-icon-minus').addClass('seemore ui-icon-plus');
	  }else{
		$(this).next(".group").slideUp(150);
		$("#index .container h3 .more").removeClass('seeless ui-icon-minus').addClass('seemore ui-icon-plus');
		$(this).next(".group").removeClass('active');
		$("#index .toggleall").removeClass('seeless ui-icon-minus').addClass('seemore ui-icon-plus');
	  }
	});
	$("<div class='toggleall seemore ui-icon ui-icon-plus' />").prependTo("#index h2");
	$("#index h2").click(function(){
	  if($(this).find('.toggleall').hasClass("seemore")){
		$("#index .group").slideDown(150);
		$("#index .group").addClass('active');
		$('#index h3 .more').removeClass('seemore ui-icon-plus').addClass('seeless ui-icon-minus');
		$(this).find('.toggleall').removeClass('seemore ui-icon-plus').addClass('seeless ui-icon-minus');
	  }else{
		$("#index .group").slideUp(150);
		$("#index .group").removeClass('active');
		$('#index h3 .more').removeClass('seeless ui-icon-minus').addClass('seemore ui-icon-plus');
		$(this).find('.toggleall').removeClass('seeless ui-icon-minus').addClass('seemore ui-icon-plus');
	  }
	});
  }
}
/* Clone the navigator */
function cloneNavigator(){
	$(document).on('click','.navigator-clone :submit',function(event){
		event.preventDefault();
		var cloneOf=$(":submit[name='"+$(this).attr('value')+"']").filter(":first");
		$(cloneOf).removeProp('disabled').removeClass('disabled').click();
	});
	$("<div class='navigator-clone tool'/>").appendTo(".cloned-tools");
	$(".navigator button").each(function(){
		$(this).clone().removeAttr("id").removeAttr("name").removeAttr("accesskey").appendTo('.navigator-clone');
	});
}
/* Fix the header */
function headerFixed(){
	$("#head").wrap( "<div class='head affix'></div>" );;// Use same class than bootstrap
	if($(".pagesubtitle").length==1){
		$(".pagesubtitle").css("padding-top",$("#head").outerHeight());
	}else{
		$("#content").css("padding-top",$("#head").outerHeight());
	}
}
/* Replace jquery ui progressbar */
if(!useDefaultProgress && bHaveJquery){
	jQuery(function($) {
		$.fn.progressbar = function(option) {
			return $(this).each(function() {
			var obj = $(this);
			if(typeof option.value== "number"){
				htmlProgress="<div class='progress-bar'><div class='progress-value' style='width:"+option.value+"%'>"+option.value+"%</div><div class='progress-over' />";
				position=0;
				for (i = 100; i > 0; i-=10)
				{
					htmlProgress+="<div class='progress-range range-"+i+"' style='right:"+position+"%'>"+i+"%</div>";
					position+=10;
				}
				htmlProgress+="</div>";
				$(this).parent().addClass("skeletonprogress");
				$(this).append(htmlProgress).addClass("skeletonprogress");
			}
			// Move preprogress
			txtPreprogress=$("#progress-wrapper > .hide").text();
			txtPreprogress=false;//comment to activate
			if(txtPreprogress){
				$(this).prepend("<div class='preprogress' style='float:left'>"+txtPreprogress+"</div>");
				$(this).find(".progress-bar").css("margin-left",$(this).find(".preprogress").outerWidth()+"px");
			}
			});
		}
	});
}
function fixLabelClass(){
	$(document).on('click','td.radio-item [type=radio]',function(){
		$('[type=radio][name="'+$(this).attr('name')+'"]').not(this).each(function(){
			$(this).closest('td').removeClass('checked');
		});
		$(this).closest('td').addClass('checked');
	});
	$(document).ready(function(){
		$('td.radio-item [type=radio][checked]').each(function(){
			$(this).closest('td').addClass('checked');
		});
	});
	$(document).on('click','td.checkbox-item',function(){
		if($(this).find("[type=checkbox]").is(':checked')){
			$(this).closest('td').addClass('checked');
		}else{
			$(this).closest('td').removeClass('checked');
		}
	});
	$(document).ready(function(){
		$('td.radio-item [type=radio][checked]').each(function(){
			$(this).closest('td').addClass('checked');
		});
	});
	$(document).ready(function(){
		$('td.checkbox-item [type=checkbox][checked]').each(function(){
			$(this).closest('td').addClass('checked');
		});
	});
	/* Move radio before label to have same HTML in list and in table */
	$(document).ready(function(){
		$('td.radio-item label + [type=radio]').each(function(){
			$(this).insertBefore($(this).prev('label'));
		});
	});
	$(document).on('blur focusout','li.other-item [type=text]',function(){
		if($(this).val()!=''){
			$(this).closest('li.other-item').addClass('checked');
		}else{
			$(this).closest('li.other-item').removeClass('checked');
		}
	});
	/* Radio list text */
	$(document).ready(function(){
		$('li.radio-item.other-item [type=radio]').not("[checked]").each(function(){
			$(this).closest('li').find('[type=text]').prop('disabled',true);
		});
		$('li.radio-item.other-item [type=radio][checked]').each(function(){
			$(this).closest('li').addClass('checked');
		});
	});
	$(document).on('click','li.radio-item:not(.other-item) [type=radio]',function(){
		$(this).closest('ul').find('li.other-item').removeClass('checked');
		$(this).closest('ul').find('li.other-item').find("input[type=text]").prop('disabled',true);
	});
	$(document).on('click','li.other-item [type=radio]',function(event){
		$(this).closest(".other-item").find("input[type=text]").prop('disabled',false);
		$(this).closest(".other-item").addClass('checked');
		event.stopPropagation();
	});
	$(document).on('click','li.other-item',function(){
		$(this).find("input[type=radio]").click();
		$(this).closest(".other-item").find("input[type=text]").focus();
	});
	$(document).on('click','td.checkbox-item,td.radio-item',function(){
		$(this).find("input[type=checkbox],input[type=radio]").focus();
	});
}
/* Fix multi popup if there are different error */
function showStartPopups(){
    if(typeof showpopup=="undefined"){showpopup=1;}
    if(typeof startPopups=="undefined"){startPopups=[];}
    if(showpopup){
		var popuptext="";
        $.each(startPopups,function(key, text){
            popuptext+="<p>"+$("<div/>").html(text).text()+"</p>";// Parse HTML because of &#039;
        });
        if(popuptext)
        {
			var $dialog = $('<div></div>')
				.html(popuptext)
				.dialog({
					title: '',
					dialogClass: 'alert',
					buttons: { "Ok": function() { $(this).dialog("close"); } },
					show: { effect: "highlight", duration: 800 },
					hide: {effect: "fade",duration: 500},
					modal: true
				});
			$dialog.dialog('open');
		}
    }
}


function shuffleArray(array) {
	for (var i = array.length - 1; i > 0; i--) {
		var j = Math.floor(Math.random() * (i + 1));
		var temp = array[i];
		array[i] = array[j];
		array[j] = temp;
	}
	return array;
}

	
/*****
    A jQuery plugin to facilitate the Van Westendorp pricing research methodology
    Copyright (C) 2016 - Tony Partner (http://partnersurveys.com)
    Licensed MIT, GPL
    Version - 2.0
    Create date - 19/10/16
*****/
(function( $ ){

	$.fn.vWPricing = function(options) {  
	
		var opts = $.extend( {
			order: [1, 2, 3, 4],
			randomOrder: false
		}, options);
		
		return this.each(function() { 
				
			var thisQuestion = $(this);
			
			thisQuestion.addClass('vwp-question');
			
			// Add some attributes and set the slider max/min values
			var itemsLength = $('li.question-item', thisQuestion).length;
			$('li.question-item', thisQuestion).each(function(i) {
				$(this).attr('data-item', (i+1));
				$('.ui-slider', this).attr('data-slider', (i+1));
				
				var thisSliderMin = $('.ui-slider', this).slider('option', 'min');
				$('.ui-slider', this).slider('option', 'min', thisSliderMin+(i));
				var thisSliderMax = $('.ui-slider', this).slider('option', 'max');
				$('.ui-slider', this).slider('option', 'max', thisSliderMax-((itemsLength-1)-i));
			});
			
			// Slider order
			if(opts.randomOrder == true) {
				shuffleArray(opts.order);
			}
			$(opts.order).each(function(i, val) {
				$('ul.subquestions-list', thisQuestion).append($('li.question-item[data-item="'+val+'"]', thisQuestion));
			});
	
			// Listeners on the sliders
			$('.ui-slider', thisQuestion).on('slide', function(event, ui) {
				handleVwpSliders(this, ui.value);
			});	
			$('.ui-slider', thisQuestion).on('slidestop', function(event, ui) {
				handleVwpSliders(this, ui.value);
			});
			
			// A function to handle the siders
			function handleVwpSliders(el, sliderVal) {
				var thisRow = $(el).closest('li');
				var movedIndexNum = $(el).attr('data-slider');
				
				$('input.text', thisRow).val(sliderVal);
				$('.slider-callout', thisRow).html($('input.text', thisRow).val());
				
				var lowerSliders = $('.ui-slider', thisQuestion).filter(function() {
					return $(this).attr('data-slider') < movedIndexNum;
				});
				var higherSliders = $('.ui-slider', thisQuestion).filter(function() {
					return $(this).attr('data-slider') > movedIndexNum;
				});
				
				$(lowerSliders).each(function(i) {
					var thisIndexNum = $(this).attr('data-slider');
					var newSliderVal = sliderVal-(movedIndexNum-thisIndexNum);
					if($(this).slider('option', 'value') > newSliderVal) {
						var thisRow = $(this).closest('li');
						$(this).slider('option', 'value', newSliderVal);
						$('input.text', thisRow).val(newSliderVal);
						$('.slider-callout', thisRow).html($('input.text', thisRow).val());
					}
				});
				$(higherSliders).each(function(i) {
					var thisIndexNum = $(this).attr('data-slider');
					var newSliderVal = sliderVal+(thisIndexNum-movedIndexNum);
					if($(this).slider('option', 'value') < newSliderVal) {
						var thisRow = $(this).closest('li');
						$(this).slider('option', 'value', newSliderVal);
						$('input.text', thisRow).val(newSliderVal);
						$('.slider-callout', thisRow).html($('input.text', thisRow).val());
					}
				});
			}
		});
	
	};
})( jQuery );