/*
 * LimeSurvey
 * Copyright (C) 2007 The LimeSurvey Project Team / Carsten Schmitz
 * All rights reserved.
 * License: GNU/GPL License v2 or later, see LICENSE.php
 * LimeSurvey is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 * 
 * 
 * Description: Javascript file for templates. Put JS-functions for your template here.
 *  
 * 
 * $Id:$
 */


/*
 * The function focusFirst puts the Focus on the first non-hidden element in the Survey. 
 * 
 * Normally this is the first input field (the first answer).
 */
function focusFirst(Event)
{
	
	$('#limesurvey :input:visible:enabled:first').focus();

}
/*
 * The focusFirst function is added to the eventlistener, when the page is loaded.
 * 
 * This can be used to start other functions on pageload as well. Just put it inside the 'ready' function block
 */

/* Uncomment below if you want to use the focusFirst function */
/*
$(document).ready(function(){
	focusFirst();
});
*/



function cardSort(qID) {
	
	// Define some stuff...
	var thisQuestion = $('#question'+qID);
	var thisQuestionHelp = $('img[alt="Help"]', thisQuestion).parent();	
	thisQuestion.addClass('card-sort-question');
	
	// Hide the "Help" section
	thisQuestionHelp.hide();
	
	//Insert the "card sort" elements
	$('ul.questions-list', thisQuestion).parent().prepend('<div class="droppable items-start"></div><div class="items-end-wrapper" />');
	$('ul:eq(0) li', thisQuestionHelp).each(function(i) {
		$('.items-end-wrapper', thisQuestion).append('<div class="items-end-inner">\
													<div class="items-end-text">'+$(this).html()+'</div>\
													<div class="droppable items-end items-end-'+(i+1)+'" data-items-end="'+(i+1)+'"></div>\
												</div>')});
	
	// Insert the "cards"
	$('li.answer-item', thisQuestion).each(function(i) {
		var thisSGQA = $(this).attr('id').replace(/javatbd/, '');
		var thisCode = $(this).attr('id').split('X'+qID)[1];
		var thisHTML = $('label', this).html();
		$('div.items-start').append('<div class="card draggable" data-sgqa="'+thisSGQA+'" data-code="'+thisCode+'">\
										'+thisHTML+'\
									</div>');
	});			
		
	// Make the "cards" draggable
	$('.draggable').draggable({ 
		revert: "invalid", 
		zIndex: 2700, 
		helper: 'original',
		start: function( event, ui ) {
			$(ui.helper).addClass('ui-draggable-helper');
		},
		stop: function( event, ui ) {
		}
	});
	
	// Set the targets for the draggables
	$('.droppable.items-start').droppable({ 
		hoverClass: 'target-hover', 
		accept: '.draggable.moved' 
	});
	$('.droppable.items-end').droppable({ 
		hoverClass: 'target-hover', 
		accept: '.draggable' 
	});

	// After dropped
	$('.droppable').bind('drop', function(event, ui) {
		
		// Physically move the draggable to the target 
		// (the plugin just visually moves it)
		// (need to use a clone here to fake out iPad)
		var newDraggable = $(ui.draggable).clone();
		$(newDraggable).appendTo(this);
		$(ui.draggable).remove();
		if($(this).hasClass('items-end')) {
			$(newDraggable).addClass('moved');
		}
		else {
			$(newDraggable).removeClass('moved');
		}
		$(newDraggable).removeClass('ui-draggable-helper ui-draggable-dragging').css({
			'z-index':'',
			'top':'auto', 
			'left':'auto'
		});
		
		// Now, make this new clone draggable
		$(newDraggable).draggable({ 
			revert: "invalid", 
			zIndex: 2700, 
			helper: 'original',
			start: function( event, ui ) {
				$(ui.helper).addClass('ui-draggable-helper');
			},
			stop: function( event, ui ) {
			}
		});
	});
	
	// Initial "card" positions
	$('li.question-item input.text', thisQuestion).each(function(i) {
		if($(this).val() > 0) {
			$('.items-end[data-items-end="'+$(this).val()+'"]').append($('.card[data-sgqa="'+$(this).attr('name')+'"]'));
			$('.card[data-sgqa="'+$(this).attr('name')+'"]').appendTo($('.items-end[data-items-end="'+$(this).val()+'"]')).addClass('moved');
		}
	});
	
	// Interrupt the Next/Submit function and load the inputs
	$('form#limesurvey').submit(function(){
		$('.question-item input.text', thisQuestion).val(0);
		$('.droppable.items-end .card', thisQuestion).each(function(i) {
			var thisItemsEnd = $(this).closest('.droppable.items-end').attr('data-items-end');
			var thisID = $(this).attr('data-sgqa');
			$('#answer'+thisID+'').val(thisItemsEnd);
		});
	});
}
