/*
 * LimeSurvey
 * Copyright (C) 2007 The LimeSurvey Project Team / Carsten Schmitz
 * All rights reserved.
 * License: GNU/GPL License v2 or later, see LICENSE.php
 * LimeSurvey is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 * 
 * 
 * Description: Javascript file for templates. Put JS-functions for your template here.
 *  
 * 
 * $Id:$
 */


/*
 * The function focusFirst puts the Focus on the first non-hidden element in the Survey. 
 * 
 * Normally this is the first input field (the first answer).
 */
function focusFirst(Event)
{
	
	$('#limesurvey :input:visible:enabled:first').focus();

}
/*
 * The focusFirst function is added to the eventlistener, when the page is loaded.
 * 
 * This can be used to start other functions on pageload as well. Just put it inside the 'ready' function block
 */

/* Uncomment below if you want to use the focusFirst function */
/*
$(document).ready(function(){
	focusFirst();
});
*/



function correctPNG() // correctly handle PNG transparency in Win IE 5.5 & 6.
{
   var arVersion = navigator.appVersion.split("MSIE")
   var version = parseFloat(arVersion[1])
   if ((version >= 5.5) && (version<7) && (document.body.filters)) 
   {
      for(var i=0; i<document.images.length; i++)
      {
         var img = document.images[i]
         var imgName = img.src.toUpperCase()
         if (imgName.substring(imgName.length-3, imgName.length) == "PNG")
         {
            var imgID = (img.id) ? "id='" + img.id + "' " : "";
            var imgClass = (img.className) ? "class='" + img.className + "' " : "";
            var imgTitle = (img.title) ? "title='" + img.title + "' " : "title='" + img.alt + "' ";
            var imgStyle = "display:inline-block;" + img.style.cssText;
            if (img.align == "left") imgStyle = "float:left;" + imgStyle;
            if (img.align == "right") imgStyle = "float:right;" + imgStyle;
            if (img.parentElement.href) imgStyle = "cursor:hand;" + imgStyle;
            var strNewHTML = "<span " + imgID + imgClass + imgTitle
            + " style=\"" + "width:" + img.width + "px; height:" + img.height + "px;" + imgStyle + ";"
            + "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader"
            + "(src='" + img.src + "', sizingMethod='scale');\"></span>" 
            img.outerHTML = strNewHTML
            i = i-1
         }
      }
   }    
}

$(document).ready(function(){

});

// A plugin to insert an IAT interface
function implicitAssociation(el, showAnswers) {
		
	$(el).each(function() {
			
		var thisQuestion = $(this);
		var thisQuestionHelp = $('img[src$="help.gif"]', thisQuestion).parent();
		var thisQuestionAnswers = $('table.question', thisQuestion).parent();
		var startTime = '';
		var endTime = '';	
		var agent = navigator.userAgent.toLowerCase();
		var mobile = false;
		if( /android|webos|iphone|ipad|ipod|blackberry/i.test(navigator.userAgent) ) { // Mobile devices
			mobile = true;
		}
		
		// Some classes
		$(thisQuestion).addClass('iatQuestion');
		$('.subquestion-list').addClass('unanswered');
		
		// Hide the question help element
		$(thisQuestionHelp).hide();
		
		// Hide the answers
		if(showAnswers != true) {
			$('table.question', thisQuestion).hide();
		}
		
		// Insert IAT display
		var iatTexts = $(thisQuestionHelp).text().split('||');
		var iatDisplayHTML = '<div class="iatWrapper">\
								<div class="iatLeftLabel">'+iatTexts[0]+'</div>\
								<div class="iatRightLabel">'+iatTexts[1]+'</div>\
								<div class="iatWord"></div>\
								<div class="iatInstructions">'+iatTexts[2]+'</div>\
							</div>\
							<div class="iatMobileButtonWrapper">\
								<div class="iatButton iatLeftButton">E</div>\
								<div class="iatButton iatRightButton">I</div>\
								<div style="width:100%; clear:both;"></div>\
							</div>';
		$(thisQuestionAnswers).prepend(iatDisplayHTML);
		
		// Show a word
		function iatShowWord() {
			$('div.iatWord', thisQuestion).text($('.subquestion-list.unanswered:first .answertext', thisQuestion).text());
			startTime = new Date();
			
			$(document).bind('keypress.iatKeypress', function(e) {
				if(e.which == 101 || e.which == 105) {
					var thisRow = $('.subquestion-list.unanswered:eq(0)', thisQuestion);
					$(thisRow).removeClass('unanswered');
					endTime = new Date();
					$('input[type="text"]:eq(1)', thisRow).val(endTime.valueOf() - startTime.valueOf());
					if(e.which == 101) {
						$('input[type="text"]:eq(0)', thisRow).val('E');
					}
					else {
						$('input[type="text"]:eq(0)', thisRow).val('I');
					}
					$(document).unbind('keypress.iatKeypress');
					if($('.subquestion-list.unanswered', thisQuestion).length > 0) {
						iatShowWord();
					}
					else {
						$('.iatLeftLabel, .iatWord, .iatRightLabel, .iatInstructions', thisQuestion).fadeOut('slow', function() {
							$('div.iatWord', thisQuestion).text(iatTexts[3]);
							$('.iatWord', thisQuestion).addClass('done').fadeIn('slow');
						});
					}
				}
			});
		}
		function iatShowWordMobile() {
			$('div.iatWord', thisQuestion).text($('.subquestion-list.unanswered:first .answertext', thisQuestion).text());
			startTime = new Date();
			
			$('.iatButton', thisQuestion).bind('click.iatButtonClick', function(e) {
				var thisRow = $('.subquestion-list.unanswered:eq(0)', thisQuestion);
				$(thisRow).removeClass('unanswered');
				endTime = new Date();
				$('input[type="text"]:eq(1)', thisRow).val(endTime.valueOf() - startTime.valueOf());
				$('input[type="text"]:eq(0)', thisRow).val($(this).text());
				$('.iatButton', thisQuestion).unbind('click.iatButtonClick');
				if($('.subquestion-list.unanswered', thisQuestion).length > 0) {
					iatShowWordMobile();
				}
				else {
					$('.iatLeftLabel, .iatWord, .iatRightLabel, .iatInstructions, .iatMobileButtonWrapper', thisQuestion).fadeOut('slow', function() {
						$('div.iatWord', thisQuestion).text(iatTexts[3]);
						$('.iatWord', thisQuestion).addClass('done').fadeIn('slow');
					});
				}
			});
		}
		
		// Start the IAT display
		if(mobile == true) { // Mobile devices
			$('.iatMobileButtonWrapper', thisQuestion).show();
			$('.iatButton', thisQuestion).bind('click.iatStartMobile', function(e) {
				$('.iatButton', thisQuestion).unbind('click.iatStartMobile');
				iatShowWordMobile();
			});
		}
		else {
			$(document).bind('keypress.iatStart', function(e) { // Non-mobile devices
				if(e.which == 101 || e.which == 105) {
					$(document).unbind('keypress.iatStart');
					iatShowWord();
				}
			});
		}
	});
} 
