
	
	$(document).ready(function(){
		
		$('.numeric-multi:eq(0)').lsRangeSlider();
		
		$('.numeric-multi:eq(1)').lsRangeSlider({
			sliderMin :50, // Minimum slider value (default 0)
			sliderMax :150, // Maximum slider value (default 100) 
			rangeStartMin :80, // Minimum range handle start value  
			rangeStartMax :120, // Maximum range handle start value  
			minRangeSpan :10, // Minimum allowed range span 
			step :2, // Slider increments (default 1)
			width :350, // Width of slider in pixels (default 250)
			recordStart :true, // Record the start value? (default no)
			showMin :true, // Show slider minimum value? (default no)
			showMax :true // Show slider maximum value? (default no)
		});
		
	});

// NO EDITING REQUIRED BELOW HERE
	
// A jQuery plugin to display a range slider in LimeSurvey
(function( $ ){

	$.fn.lsRangeSlider = function(options) {  
	
		// The defaults, extended and modified with any passed in the function call
		var opts = $.extend( {
			range		:true, 
			sliderMin		:0, 
			sliderMax		:100,
			rangeStartMin	:'',
			rangeStartMax	:'',
			minRangeSpan	:0,
			step			:1,
			width			:250, 
			recordStart		:false,
			showMin			:false,
			showMax			:false
		}, options);
		
		return this.each(function() { 
		
			if($(this).hasClass('numeric-multi') && $('input.text', this).length == 2) {
				
				// Define some vars	
				var $this = $(this);
				var qID = $(this).attr('id').split('question')[1];
				var rangeMinInput = $('input.text:eq(0)', $this); 
				var rangeMaxInput = $('input.text:eq(1)', $this); 
				
				// Some classes for the question and sub-questions
				$this.addClass('range-slider-question');
					
				// Check for pre-existing answer
				if($(rangeMinInput).val() != '' && $(rangeMinInput).val() != '') {
					opts.rangeStartMin = $(rangeMinInput).val();
					opts.rangeStartMax = $(rangeMaxInput).val();
				}
					
				// Insert the slider elements
				$('.subquestions-list', $this).before(
					'<div class="range-slider-wrapper"> \
						<div class="range-slider-min"></div> \
						<div id="range-slider-'+qID+'" class="range-slider" style="width:'+opts.width+'px;"> \
							<div class="range-slider-callout" id="slider-callout-min-'+qID+'"></div> \
							<div class="range-slider-callout" id="slider-callout-max-'+qID+'"></div> \
						</div> \
						<div class="range-slider-max"></div> \
						<div style="clear:both;"></div> \
					</div>'
				);
				
				// Show min/max if option is set
				if(opts.showMax) {
					$('.range-slider-max', $this).text(opts.sliderMax);
				}
				if(opts.showMin) {
					$('.range-slider-min', $this).text(opts.sliderMin);
				}
				
				// Initiate the slider
				var rangeMin;
				var rangeMax;
				if(opts.rangeStartMin == '' || opts.rangeStartMin < opts.sliderMin || opts.rangeStartMin > opts.rangeStartMax) {
					rangeMin = opts.sliderMin+((opts.sliderMax-opts.sliderMin)*0.3333);
				}
				else {
					rangeMin = opts.rangeStartMin;
				}
				if(opts.rangeStartMax == '' || opts.rangeStartMax > opts.sliderMax || opts.rangeStartMax < opts.rangeStartMin) {
					rangeMax = opts.sliderMin+((opts.sliderMax-opts.sliderMin)*0.6667);
				}
				else {
					rangeMax = opts.rangeStartMax;
				}
				$('#range-slider-'+qID).slider({
					range: true,
					min: opts.sliderMin,
					max: opts.sliderMax, 
					values: [ rangeMin, rangeMax ],
					step: opts.step,
					slide: function(event, ui) {
						if((ui.values[1] - ui.values[0]) < opts.minRangeSpan) {
							return false; // Nothing happens if less than minRangeSpan
						}
						$(rangeMinInput).val(ui.values[0]);
						$(rangeMaxInput).val(ui.values[1]);
						fixnum_checkconditions($(rangeMinInput).attr('value'), $(rangeMinInput).attr('name'), $(rangeMinInput).attr('type'));
						fixnum_checkconditions($(rangeMaxInput).attr('value'), $(rangeMaxInput).attr('name'), $(rangeMaxInput).attr('type'));
						$('#slider-callout-min-'+qID).text(ui.values[0]);
						$('#slider-callout-max-'+qID).text(ui.values[1]);
						setTimeout(function() { 
							$('#slider-callout-min-'+qID).css({ 'left':$('.ui-slider-handle:eq(0)', $this).position().left - $('#slider-callout-min-'+qID).outerWidth() - ($('.ui-slider-handle:eq(1)', $this).outerWidth()/2)+'px' }).show();
							$('#slider-callout-max-'+qID).css({ 'left':($('.ui-slider-handle:eq(1)', $this).position().left)+($('.ui-slider-handle:eq(1)', $this).outerWidth()/2)+'px' }).show();
						}, 10);
					},
					create: function(event, ui) {
						// Initial values and positions
						if($(rangeMinInput).val() != '' && $(rangeMaxInput).val() != '') { // Pre-existing answer
							$('#slider-callout-min-'+qID).text(opts.rangeStartMin);
							$('#slider-callout-max-'+qID).text(opts.rangeStartMax);
						}
						else if(opts.recordStart && opts.rangeStartMin && opts.rangeStartMin && $(rangeMinInput).val() == '' && $(rangeMaxInput).val() == '') { // Record the start value (if option is set)
							$(rangeMinInput).val(opts.rangeStartMin);
							$(rangeMaxInput).val(opts.rangeStartMax);
							fixnum_checkconditions($(rangeMinInput).attr('value'), $(rangeMinInput).attr('name'), $(rangeMinInput).attr('type'));
							fixnum_checkconditions($(rangeMaxInput).attr('value'), $(rangeMaxInput).attr('name'), $(rangeMaxInput).attr('type'));
							$('#slider-callout-min-'+qID).text(opts.rangeStartMin);
							$('#slider-callout-max-'+qID).text(opts.rangeStartMax);
						}
						else {
							$('.range-slider-callout', $this).hide();
						} 
						$('#slider-callout-min-'+qID).css({ 'left':$('.ui-slider-handle:eq(0)', $this).position().left - $('#slider-callout-min-'+qID).outerWidth() - ($('.ui-slider-handle:eq(1)', $this).outerWidth()/2)+'px' });
						$('#slider-callout-max-'+qID).css({ 'left':($('.ui-slider-handle:eq(1)', $this).position().left)+($('.ui-slider-handle:eq(1)', $this).outerWidth()/2)+'px' });
					}
				});
			}
		});
	
	};
})( jQuery );

	
	

	

	
	
	
	