/******************************************

A modified version of Image Tick v1.0 for jQuery
==========================================
This modification optimizes the plugin for LimeSurvey
------------------------------------------
Originally written by Jordan Boesch, modified by Tony Partner 
Jordan Boesch - www.boedesign.com
Tony Partner - www.partnersinc.biz

V1.3
22/03/2012

******************************************/

(function($){
		  
	$.fn.imageTick = function(options) {
		
		var defaults = {	
			tick_image_path: "images/radio.gif",
			no_tick_image_path: "no_images/radio.gif",
			image_tick_class: "ticks_" + Math.floor(Math.random()),
			hide_radios_checkboxes: false
		};
	  	
		var opt = $.extend(defaults, options);
		
		// Add some classes to the arrays for manipulation
		$('.array-flexible-row, .array-flexible-duel-scale, .array-flexible-column, .array-yes-uncertain-no, .array-increase-same-decrease, .array-5-pt, .array-10-pt').addClass('radioArray');
		
		this.each(function(){
			
			var obj = $(this);
			var type = obj.attr('type'); // radio or checkbox
			
			// Hide them and store an image background
			var id = obj.attr('id').replace(/#/, '__');
			var imgHTML = '<img src="' + opt.no_tick_image_path + '" alt="no_tick" class="' + opt.image_tick_class + '" id="tick_img_' + id + '" />';
			
			obj.before(imgHTML);
			if(!opt.hide_radios_checkboxes){
				obj.css({ 'position':'absolute', 'left':'-99999px' });
			}
			
			// if something has a checked state when the page was loaded
			if(obj.attr('checked')){
				$('#tick_img_'+id).attr('src', opt.tick_image_path);
			}
			
			
			// Array questions
			if(type == 'radio' && $(obj).parents('div[id^="question"]').hasClass('radioArray')){
				
				$(obj).parents('td:eq(0)').addClass('imageTickCellA radio-group-'+$(obj).attr('name').replace(/#/, '_'));
				
				// Click on the answer cell in an array
				$(obj).parents('td:eq(0)').click(function(event){
					event.stopPropagation();
					var groupClass = ''
					var classes = $(this).attr("className").split(' ');
					$(classes).each(function(i){
						if(this.substr(0,12) == 'radio-group-') {
							groupClass = this;
						}
					}); 
					$('td.'+groupClass+' img').attr('src', opt.no_tick_image_path);
					//$('#'+id).trigger('click');
					$('#tick_img_'+id).attr('src', opt.tick_image_path);
				});
				
			}
			// Radio questions
			else if(type == 'radio'){
								
				// Click on the image
				$("#tick_img_"+id).click(function(){
					var el = $(this).parents('div[id^="question"]');
					$("." + opt.image_tick_class + "", el).attr('src', opt.no_tick_image_path);
					$('#'+id).trigger('click');
					$(this).attr('src', opt.tick_image_path);
				});
				
				// Click on the label
				$("label[for='" + id + "']").click(function(){
					var el = $(this).parents('div[id^="question"]');
					$("." + opt.image_tick_class + "", el).attr('src', opt.no_tick_image_path);
					$('#'+id).trigger('click');
					$('#tick_img_'+id).attr('src', opt.tick_image_path);
				});
				
			}				
			// Array-numbers-checkboxes questions
			else if(type == 'checkbox' && $(obj).parents('div[id^="question"]').hasClass('array-multi-flexi')){
				
				$(obj).parents('td:eq(0)').addClass('imageTickCellC');
				
				// Click on the answer cell in an array
				$(obj).parents('td:eq(0)').click(function(){
					if($('#tick_img_'+id).attr('src') == opt.no_tick_image_path){
						$('#tick_img_'+id).attr('src', opt.tick_image_path);
					}
					else {
						$('#tick_img_'+id).attr('src', opt.no_tick_image_path);	
					}								
				});
				
			}		
			// Checkbox with comments questions
			else if(type == 'checkbox' && $(obj).parents('div[id^="question"]').hasClass('multiple-opt-comments')){
							
				// Click on the image
				$('#tick_img_'+id).click(function(event){
					if($(this).siblings('input.checkbox').attr('disabled') == true){
						return false;
					}
					$("label[for='" + id + "']").trigger("click");
					event.stopPropagation();
					// Handle the exlusive options
					handleExclusive(id);
				});
				
				// Click on the label
				$("label[for='" + id + "']").click(function(){
					if($(this).siblings('input.checkbox').attr('disabled') == true){
						return false;
					}
					if($('#tick_img_'+id).attr('src') == opt.no_tick_image_path){
						$('#tick_img_'+id).attr('src', opt.tick_image_path);
					}
					else {
						$('#tick_img_'+id).attr('src', opt.no_tick_image_path);
						// Clear the comment field
						$('#'+id+'comment').val('');	
					}
					// Handle the exlusive options
					handleExclusive(id);
				});
				
				// Handle the image if the comment field is populated
				var listItem = $(obj).parents('li:eq(0)');
				$('input.text', listItem).change(function(){
					if($.trim($(this).val()) != '') {
						$('#tick_img_'+id).attr('src', opt.tick_image_path);
					}
					// Handle the exlusive options
					handleExclusive(id);
				});
				
			}		
			// Checkbox questions
			else if(type == 'checkbox'){
							
				// Click on the image
				$('#tick_img_'+id).click(function(){
					if($(this).siblings('input.checkbox').attr('disabled') == true){
						return false;
					}
					else {
						$('#'+id).trigger('click');
						if($(this).attr('src') == opt.no_tick_image_path){
							$(this).attr('src', opt.tick_image_path);
						}
						else {
							$(this).attr('src', opt.no_tick_image_path);	
						}
						checkconditions($('#'+id).attr('value'), $('#'+id).attr('name'), $('#'+id).attr('type'));
						// Handle the exlusive options
						handleExclusive(id);
					}
				});
				
				// Click on the label
				$("label[for='" + id + "']").click(function(){
					if($(this).siblings('input.checkbox').attr('disabled') == true){
						return false;
					}
					if($('#tick_img_'+id).attr('src') == opt.no_tick_image_path){
						$('#tick_img_'+id).attr('src', opt.tick_image_path);
					}
					else {
						$('#tick_img_'+id).attr('src', opt.no_tick_image_path);	
					}
					// Handle the exlusive options
					handleExclusive(id);
				});
				
			}
				
			function handleExclusive(id) {
				// A little delay to let checkconditions() happen (this may need to be increased)
				setTimeout(function() {
					var parentList = $('#'+id).parents('ul:eq(0)');
					$('input.checkbox', parentList).each(function(i){
						if($(this).attr('disabled') == true) {
							$(this).siblings('img.checkboxes').css({ opacity: 0.35 });
						}
						else {
							$(this).siblings('img.checkboxes').css({ opacity: 1 });
						}
					});
				}, 150);				
			}
			
		});
	}
	
})(jQuery);
